#include "ETHHeader.h"
#include <iomanip>

ETHHeader::ETHHeader(const u_char *_dst, const u_char *_src, u_short _frame_type) 
{
  memset(&data, 0, ETH_HEADER_SIZE);
  for (int i = 0; i < ETH_ALEN; i++)
  {
    data.dst[i] = _dst[i];
    data.src[i] = _src[i];
  }
  data.frame_type = _frame_type;
}

ETHHeader::ETHHeader(const u_char *_data)
{	
  memcpy(&data, _data, ETH_HEADER_SIZE);
  data2host();
}

void ETHHeader::dump() 
{
  cout << "Eth Header:" << endl;
  cout << "  Source MAC: ";
  printMACAddress(data.src);
  cout << endl << "Destination MAC: ";
  printMACAddress(data.dst);
  cout << endl << "Frame_Type: 0x" << setbase(16) << setfill('0') << setw(4) << data.frame_type << setfill(' ') << setbase(10) << endl << endl << endl;
}

void ETHHeader::setMem(u_char *_data)
{
  data2network();
  memcpy(_data, &data, sizeof(data));            
  data2host();
}

u_short ETHHeader::frame_type() { 
  return this->data.frame_type; 
}

const u_char *ETHHeader::dst_MAC() const { 
  return this->data.dst; 
}

const u_char *ETHHeader::src_MAC() const { 
  return this->data.src; 
}

void ETHHeader::data2host(void) {
  data.frame_type = ntohs(data.frame_type);
}

void ETHHeader::data2network(void) {
  data.frame_type = htons(data.frame_type);
}
